<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Classes\CJApi;
use Illuminate\Support\Facades\Http;
use App\Models\product;
use App\Models\category;
class CJController extends Controller
{
    public function __construct()
    {
        $this->email = env('CJ_EMAIL');
        $this->password = env('CJ_PASSWORD');
        $this->baseUrl = env('CJ_API_BASE_URL');
    }
    public function getAccessToken()
    {
       // return session('access_token');
        $response = Http::post("{$this->baseUrl}/authentication/getAccessToken", [
            'email' => $this->email,
            'password' => $this->password,
        ]);

        $data = $response->json();

        if (isset($data['data']['accessToken'])) {
            session()->put('access_token',$data['data']['accessToken']);
            return $data;  // Return the access token
        }

        return $data;
    }
    public function getProducts(Request $request)
    {
        if(session('access_token')=="")
        {
            $this->getAccessToken();
        }
        $inputs=array();

        $page = $request->query('page', 1); // Default page = 1
        $categoryId = $request->query('category'); 
        $cjApi = new CJApi(); // Instantiate API class
        $response = $cjApi->getProducts($request);
        //return $products=$response['data']['list'];
         $products = [];
    foreach ($response['data']['list'] as $product) {
        $productId = $product['pid'];
        $details = $cjApi->getProductDetails($productId);
        //Merge basic product info with details
        $products[] = [
            'productId' => $productId,
            'productName' => $product['productNameEn'],
            'categoryName' => $product['categoryName'],
            'productImage' => $product['productImage'] ?? 'default.jpg',
            'sellPrice' => $product['sellPrice'] ?? 'N/A',
            'description' => $details['data']['description'] ?? 'No description available',
        ];
    }
    //return $products;
    $inputs=$request->all();
        return view('cj.products',compact('products','inputs','page'));
    }
    public function importProduct(Request $request)
    {
        $validated = $request->validate([
            'productId' => 'required|string',
            'productName' => 'required|string',
            'productPrice' => 'nullable|numeric',
            'productImage' => 'nullable|string',
            'categoryName' => 'nullable|string',
            'description' => 'nullable|string',
        ]);

        // Check if product already exists
        $existingProduct = product::where('code', $validated['productId'])->first();
        if ($existingProduct) {
            return response()->json(['success' => false, 'message' => 'Product already imported.']);
        }

        $category=category::where('name',$validated['categoryName'])->first();
        if($category)
        {

        }
        else{
            $category = new category();
            $category->code = time();
            $category->status = "public";
            $category->name = $validated['categoryName'];
            $category->save();
        }

        $product = new product();
        $product->code = $validated['productId'];
        $product->name = $validated['productName'];
        $product->category_id = $category->id ?? null;
        // $product->price = $validated['productPrice'] + ($validated['productPrice'] * 0.2);
        // $product->final_price = $validated['productPrice'] + ($validated['productPrice'] * 0.2);
        // Ensure the product price is numeric by removing any non-numeric characters (except decimal point)
        $numericPrice = isset($validated['productPrice']) ? preg_replace('/[^0-9.]/', '', $validated['productPrice']) : 0;
        $numericPrice = is_numeric($numericPrice) ? (float) $numericPrice : 0;
        
        // Calculate price with 20% added
        $product->price = $numericPrice;
        $product->final_price = round($numericPrice + ($numericPrice * 0.4), 2);
        $product->photo = $validated['productImage'] ?? null;
        $product->description = $validated['description'] ?? null;
        $product->discount = 0; // Default discount
        $product->status = "public"; // Default status
        $product->save();

        return response()->json(['success' => true, 'message' => 'Product imported successfully!']);
    }

}
