<?php

namespace App\Http\Controllers;
use App\Models\order;
use App\Models\product;
use App\Models\order_product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function analysis(Request $req)
    {
        $top_month_sellings_products =order_product::selectRaw("sum(quantity) as tq,product_id")->groupBy("product_id")->with("get_product:id,name,code,photo")->whereMonth("created_at", date("m"))->whereYear("created_at",date("Y"))->orderBy("tq","desc")->take(10)->get();
        $top_sellings_products =  order_product::selectRaw("sum(quantity) as tq,product_id")->groupBy("product_id")->with("get_product:id,name,code,photo")->orderBy("tq","desc")->take(10)->get();
    //   return $top_sellings_products =  order_product::join('products', 'order_products.product_id', '=', 'products.id')->selectRaw("sum(quantity) as tq,product_id, products.category_id")->groupBy(DB::raw('products.category_id'))->orderBy("tq","desc")->take(10)->get();
       
    //   return order_product::with("get_product:id,name,code,category_id")
    // ->join('products', 'order_products.product_id', '=', 'products.id')
    // ->selectRaw("sum(order_products.quantity) as tq, products.category_id")
    // ->groupBy('products.category_id')
    // ->orderBy('tq', 'desc')
    // ->take(10)
    // ->get();
    $top_selling_categories = order_product::
    join('products', 'order_products.product_id', '=', 'products.id')
    ->join('categories', 'products.category_id', '=', 'categories.id')
    ->selectRaw("sum(order_products.quantity) as tq, products.category_id, categories.name as category_name")
    ->groupBy('products.category_id', 'categories.name')
    ->orderBy('tq', 'desc')
    ->take(10)
    ->get();
    
    $top_generating_states = order::selectRaw("sum(total_price) as tp, state")->groupBy("state")->orderBy("tp","desc")->get();
   $top_month_generating_states = order::selectRaw("sum(total_price) as tp, state")->groupBy("state")->whereMonth("created_at", date("m"))->whereYear("created_at",date("Y"))->orderBy("tp","desc")->get();

    $top_generating_customers = order::selectRaw("sum(total_price) as tp, name, email")->groupBy("name","email")->orderBy("tp","desc")->take(10)->get();
    
    $short_products_twenty= product::select("id","name","code","photo","quantity")->where("quantity","<=","20")->get();
    $short_products_seventy = product::select("id","name","code","photo","quantity")->where("quantity","<=","70")->where("quantity",">","20")->get();

    
    
    return view("admin.orders.analysis", compact("top_month_sellings_products","top_sellings_products","top_selling_categories","top_generating_states","top_month_generating_states","top_generating_customers","short_products_twenty","short_products_seventy"));
    

    }
    public function dashboard(Request $req)
    {
        // return $this->analysis($req);
        $total_payments=order::where('payment_status', 'completed')->sum('total_price');
        $total_orders=order::count();
        $today_orders=order::whereDate("created_at",date("y-m-d"))->count();
        $today_payments=order::whereDate("created_at",date("y-m-d"))->where('payment_status', 'completed')->sum('total_price');
        $month_orders=order::whereMonth("created_at",date("m"))->whereYear("created_at",date("Y"))->count();
        $month_payments=order::whereMonth("created_at",date("m"))->whereYear("created_at",date("Y"))->where('payment_status', 'completed')->sum('total_price');
        $days_graph = order::whereMonth("created_at",date("m"))->whereYear("created_at",date("Y"))->where('payment_status', 'completed')->selectRaw("sum(total_price) as tp, DAY(created_at)")->groupBy(DB::raw('DAY(created_at)'))->get();
        $days = collect( $days_graph)->pluck("DAY(created_at)")->toArray();
        $days_amount = collect( $days_graph)->pluck("tp")->toArray();
         $date= date('Y-m-d', strtotime(' - 3 months'));
          $orders_list=order::query();
           $inputs = $req->all();
          if($req->id && $req->id!="")
          {
              $orders_list->where('order_no',$req->id);
          }
           if($req->date && $req->date!="")
          {
              $orders_list->whereDate('created_at',$req->date);
          }
           if($req->name && $req->name!="")
          {
              $orders_list->where('name',$req->name);
          }
          
          
        $orders_list=$orders_list->where("created_at",">",$date)->orderBy('created_at','desc')->paginate(50);
        return view("admin.orders.dashboard",compact("total_orders","today_orders","month_orders",
        "orders_list", "total_payments", "today_payments", "month_payments","days","days_amount","inputs"));

    }
     public function reports(Request $req)
    {
        $check = 0;
        $orders = array();
        $query = order::query();
        if($req->input("date") && $req->input("date")!="")
        {
            $check = 1;
            // return date("Y-m-d",strtotime($req->input("date")));
            $query = $query->whereDate("created_at",date("Y-m-d",strtotime($req->input("date"))));
        }
         if($req->input("month") && $req->input("month")!="")
        {
            // return $req->input("month");
            $check = 1;
            $query = $query->whereMonth("created_at",$req->input("month"));
        }
         if($req->input("year") && $req->input("year")!="")
        {
            // return $req->input("year");
            $check = 1;
            $query = $query->whereYear("created_at",$req->input("year"));
        }
         if($req->input("email") && $req->input("email")!="")
        {
            $check = 1;
            $query = $query->where("email",$req->input("email"));
        }
        $amount="";
        if($check == 1)
        {
           $amount_query = $query;
           $amount = $amount_query->sum("total_price");
           $orders =  $query->get();
        }
        // return $orders;
        $filters = $req->all();
        return view("admin.reports", compact("filters","orders","amount"));
    }
}
