<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\order_product;
use App\Models\product;
use App\Models\product_size;
use App\Models\cart;
use App\Models\order;
use App\Models\temp_detail;
use Carbon\Carbon;
use App\Http\Controllers\CartController;

class OrderController extends Controller
{
    //

    public function user_orders(Request $req)
    {
        $search_order = null;

        if ($req->order != "") {

            $search_order = order::where("order_no", $req->order)->with("getProducts")->first();
        }
        return view("user.orders", ['order' => $search_order]);
    }

    public function place_order(Request $req)
    {
        if ($req->session("cart_access_token")) {

             $req->validate([
                'state'=>'required',
                ]);


            $temp = temp_detail::where("order_no", session("cart_access_token"))->first();
            if (!$temp) {

                $carts = cart::where("token", session("cart_access_token"))->with("getProduct")->get();
                $price = cart::where("token", session("cart_access_token"))->sum("total_amount");
                $order = new temp_detail();
                $order->order_no = session("cart_access_token");
                $order->total_price = $price;
                $order->status = "pending";
                $order->name = $req->name;
                $order->last_name = $req->lname;
                $order->email = $req->email;
                $order->phone = $req->phone;
                $order->phone2 = $req->phone2;
                $order->state = $req->state;
                $order->city = $req->city;

                $order->street = $req->street;
                $order->postal_code = $req->postal_code;
                // $order->payment_status="pending";

                if ($order->save()) {
                    session()->put('oid', $order->id);
                    session()->put('total_price', $order->total_price);
                    session()->put('name', $order->name);
                    session()->put('lname', $order->last_name);
                    session()->put('email', $order->email);
                    session()->put('phone', $order->phone);
                    session()->put('phone2', $order->phone2);

                    session()->put('state', $order->state);
                    session()->put('city', $order->city);
                    session()->put('street', $order->street);
                    session()->put('postal_code', $order->postal_code);
                    // $mail=new MailController();
                    // $mail->order_mail($req,$order->id);



                    return redirect()->route("order-detail")->with(["order_status" => "true", 'order' => $order]);
                } else {
                    return redirect()->back()->with(["order_status" => "false"]);
                }
            } else {
                $price = cart::where("token", session("cart_access_token"))->sum("total_amount");
                $temp->total_price = $price;

                $temp->total_price = $price;
                $temp->status = "pending";
                $temp->name = $req->name;
                $temp->last_name = $req->lname;
                $temp->email = $req->email;
                $temp->phone = $req->phone;
                $temp->phone2 = $req->phone2;
                $temp->state = $req->state;
                $temp->city = $req->city;

                $temp->street = $req->street;
                $temp->postal_code = $req->postal_code;

                if ($temp->save()) {
                    session()->put('total_price', $temp->total_price);
                    session()->put('oid', $temp->id);
                    session()->put('name', $temp->name);
                    session()->put('lname', $temp->last_name);
                    session()->put('email', $temp->email);
                    session()->put('phone', $temp->phone);
                    session()->put('phone2', $temp->phone2);

                    session()->put('state', $temp->state);
                    session()->put('city', $temp->city);
                    session()->put('street', $temp->street);
                    session()->put('postal_code', $temp->postal_code);



                    return redirect()->route("order-detail")->with(["order_status" => "true", 'order' => $temp]);
                } else {
                    return redirect()->back();
                }
            }
        }
    }





    public function admin_orders()
    {
        $orders = order::all();
        return view("admin.orders.orders", compact("orders"));
    }
    public function admin_order_detail($order)
    {
        $order = order::where("order_no", $order)->with("getProducts")->first();
        if ($order) {
            return view("admin.orders.order_detail", compact("order"));
        } else {
            return ['Message' => 'Order was not Found'];
        }
    }

    public function update_order_status(Request $req)
    {
        if (order::where("order_no", $req->oid)->update(['status' => $req->status])) {
            $mailcont = new MailController();
            $order = order::where("order_no", $req->oid)->first();
            $mailcont->status_change_mail($req, $order->id);
            return redirect()->back()->with(["order_change_status" => "Status Changed Successfully"]);
        } else {
            return redirect()->back()->with(["order_change_status" => "Status was not Changed. Try again"]);
        }
    }

    public function orderupdate(Request $request)
    {
        $detail = temp_detail::where("order_no", session("cart_access_token"))->first();
        $carts = cart::where("token", session("cart_access_token"))->with("getProduct")->get();

        $order = new order();
        $order->order_no = session("cart_access_token");
        $order->total_price = $detail->total_price;
        $order->status = "pending";
        $order->name = $detail->name;
        $order->last_name = $detail->last_name;
        $order->email = $detail->email;
        $order->phone = $detail->phone;
        $order->phone2 = $detail->phone2;
        $order->state = $detail->state;
        $order->city = $detail->city;
        $order->street = $detail->street;
        $order->postal_code = $detail->postal_code;
        $order->payment_status = $request->status;
        $order->paypal_transaction_id = $request->tid;
        if ($order->save()) {
            foreach ($carts as $cart) {
                $product = new order_product();
                $product->product_id = $cart->product_id;
                $product->size = $cart->size;
                $product->quantity = $cart->quantity;
                $product->color = $cart->color;
                $product->unit = $cart->unit;
                $product->discount = $cart->discount;
                $product->price = $cart->price;
                $product->order_id = $order->id;
                $product->total_amount = $cart->total_amount;
                $product->save();



            }
            cart::where("token", session("cart_access_token"))->delete();
            $request->session()->pull("cart_access_token");
            session()->pull('total_price', $order->total_price);
            session()->pull('name');
            session()->pull('lname');
            session()->pull('email');
            session()->pull('phone');
            session()->pull('phone2');
            session()->pull('state');
            session()->pull('street');
            session()->pull('postal_code');
            session()->put('city');
            $cart = new CartController();
            $cart->getCartQuantity($request);
        }

        $pro_ids = order_product::where('order_id', $order->id)->get();
        $array = array();

        foreach ($pro_ids as $id) {
            $array[] = array('ids' => $id['product_id'], 'quantity' => $id['quantity']);
        }
        $this->update_product_quantity($array);

        $mail = new MailController();
        $mail->order_mail($request, $order->id);
        $mail->order_mail_to_cust($request, $order->id);
          return view('user.success',['total_amount'=>$order->total_price,'order_no'=>$order->order_no]);
        // return redirect("/orders?order=" . $order->order_no)->with(['alert' => 'true']);
    }
    public function update_product_quantity($array)
    {

        foreach ($array as $arr) {
            $product = product::find($arr['ids']);
            if ($product['quantity'] < $arr['quantity']) {
                $product->quantity = 0;
            } else {
                $product->quantity = $product->quantity - $arr['quantity'];
            }
            $product->save();
        }
    }
    public function add_delivery_detail(Request $request)
    {
        $order = order::where("order_no", $request->oid)->first();

        $order->tracking_number = $request->tid;
        $order->delivery_through = $request->d_thr;
        if ($order->save()) {
            return redirect()->back();
        } else {
            return ['key' => "Not add detils try again"];
        }
    }
    public function order_info()
    {
         $detail = temp_detail::where("order_no", session("cart_access_token"))->first();
        \Stripe\Stripe::setApiKey('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');
        $amount=$detail['total_price'];
        $amount *= 100;
        $amount = (int) $amount;
        $payment_intent = \Stripe\PaymentIntent::create([
			'description' => 'Order Payment Received',
			'amount' => $amount,
			'currency' => 'USD',
			'description' => 'Payment Of Order No '.$detail['order_no'],
			'payment_method_types' => ['card'],
		]);
		 $intent = $payment_intent->client_secret;
        return view('user.order_info2', ['order' => $detail,'intent'=>$intent]);
    }
    
       public function shipstation(Request $request)
    {
      $startDateTime = Carbon::createFromFormat('m/d/Y H:i', $request->query('start_date'))->format('Y-m-d H:i:s');
$endDateTime = Carbon::createFromFormat('m/d/Y H:i', $request->query('end_date'))->format('Y-m-d H:i:s');

  $orders = Order::whereBetween('created_at', [$startDateTime, $endDateTime])->where('status','pending')->with('getProducts')->get();

// $ordersSql = $orders->toSql();
// $bindings = $orders->getBindings();

// $orders = DB::select($ordersSql, $bindings);

// Now $orders contains the results
//dd($orders);
              
        
        $xmlOrders = '';
foreach ($orders as $order) {

$timestamp = $order->created_at;
$timestamps = $order->updated_at;

// Ensure $timestamp is an integer
$timestamp = is_numeric($timestamp) ? (int)$timestamp : strtotime($timestamp);
$timestamps = is_numeric($timestamps) ? (int)$timestamps : strtotime($timestamps);

// Format the timestamp as a string in the required format
$formattedDatetime = date('m/d/Y H:i A', $timestamp);
$formattedDatetimes = date('m/d/Y H:i A', $timestamps);



    $xmlOrders .= '
    <Order>
        <OrderID><![CDATA[' . $order->id . ']]></OrderID>
        <OrderNumber><![CDATA[' . $order->order_no . ']]></OrderNumber>
        <OrderDate><![CDATA[' . $formattedDatetime  . ']]></OrderDate>
        <OrderStatus><![CDATA[' . $order->status . ']]></OrderStatus>
        <LastModified><![CDATA[' . ($formattedDatetimes ?? "") . ']]></LastModified>
        <ShippingMethod><![CDATA[USPSPriorityMail]]></ShippingMethod>
        <PaymentMethod><![CDATA[' . $order->paypal_transaction_id . ']]></PaymentMethod>
        <CurrencyCode>USD</CurrencyCode>
        <OrderTotal><![CDATA[' . $order->total_price . ']]></OrderTotal>
        <TaxAmount><![CDATA[' . ($order->tax_amount ?? "") . ']]></TaxAmount>
        <ShippingAmount><![CDATA[' . ($order->shipping_amount ?? "") . ']]></ShippingAmount>
        <CustomerNotes><![CDATA[]]></CustomerNotes>
        <InternalNotes><![CDATA[]]></InternalNotes>
        <Gift>false</Gift>
        <GiftMessage></GiftMessage>
        <CustomField1></CustomField1>
        <CustomField2></CustomField2>
        <CustomField3></CustomField3>
        <Customer>
            <CustomerCode><![CDATA[' . $order->email . ']]></CustomerCode>
            <BillTo>
                <Name><![CDATA[' . $order->name . ']]></Name>
                <Company><![CDATA[' . $order->name . ']]></Company>
                <Phone><![CDATA[' . $order->phone . ']]></Phone>
                <Email><![CDATA[' . $order->email . ']]></Email>
            </BillTo>
            <ShipTo>
                <Name><![CDATA[' . $order->name . ']]></Name>
                <Company><![CDATA[' . $order->name . ']]></Company>
                <Address1><![CDATA[' . $order->street . ']]></Address1>
                <Address2><![CDATA[]]></Address2>
                <City><![CDATA[' . $order->city . ']]></City>
                <State><![CDATA[' . $order->state . ']]></State>
                <PostalCode><![CDATA[' . $order->postal_code . ']]></PostalCode>
                <Country><![CDATA[' . ($order->country ?? "United States") . ']]></Country>
                <Phone><![CDATA[' . $order->phone . ']]></Phone>
            </ShipTo>
        </Customer>
        <Items>';
    
    // Loop through each item in the order
    foreach ($order->getProducts as $item) {
          //die($item);
        $xmlOrders .= '
            <Item>
                <SKU><![CDATA[' . ($item->sku ?? "") . ']]></SKU>
                <Name><![CDATA[' . ($item->name ?? "") . ']]></Name>
                <ImageUrl><![CDATA[' . ( asset($item->photo) ?? " ") . ']]></ImageUrl>
                <WeightUnits><![CDATA[' . ($item->pivot->unit ?? "") . ']]></WeightUnits>
                <Quantity><![CDATA[' . ($item->pivot->quantity ?? ""). ']]></Quantity>
                <UnitPrice><![CDATA[' . ($item->pivot->price ??"" ). ']]></UnitPrice>
                <Location><![CDATA[]]></Location>
                <Options>

                </Options>
            </Item>';
    }

    $xmlOrders .= '
        </Items>
    </Order>';
}

$xmlTemplate = '<?xml version="1.0" encoding="utf-8"?>
<Orders pages="1">' . $xmlOrders . '</Orders>';

        // Serve XML content
        return response($xmlTemplate)->header('Content-Type', 'application/xml');
        
    }
}
