<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\product;
use App\Models\category;
use App\Models\unit;
use App\Models\cart;
use App\Models\product_image;
use App\Models\review;

class ProductController extends Controller
{
    //
    public function viewproduct(Request $req, $code)
    {
        $product = product::where("code", $code)->with("getReviews", function ($query) {
            $query->orderBy('id', 'desc');
        })->where("status", "public")->with('getCategory')->first();
        //return $product;
        if ($product) {

            $related_products = product::where(function ($q) use ($product) {
                $q->where("name", "like", "%" . $product->name)->orWhere("category_id", $product->category_id);
            })->where("id", "!=", $product->id)->where("status", "public")->limit(8)->get();

            $check = null;
            if ($req->session()->has("cart_access_token")) {
                $check = cart::where("product_id", $product->id)->where("token", session("cart_access_token"))->first();
            }
            $stars = 0;
            foreach ($product->getReviews as $rev) {
                $stars = $stars + $rev->stars;
            }

            //return $stars;
            if ($stars > 0) {
                $stars = $stars / sizeof($product->getReviews);
            }

            return view("user.view_product2", ['product' => $product, "check" => $check, "related_products" => $related_products, "stars" => $stars]);
        } else {
            return ['Message' => 'Not Found'];
        }
    }


    public function products()
    {
        $products = product::where("status", "public")->with('getReviews')->get();
        return view("admin.products.products", ['products' => $products]);
    }

    public function addproduct(Request $req)
    {
        return view("admin.products.addproduct", ['categories' => category::all()]);
    }

    public function editproduct($id)
    {
        $product = product::find($id);
        // return $product;
        //return $product;
        return view("admin.products.editproduct", ['categories' => category::all(), 'product' => $product]);
    }

    public function updateproduct(Request $req)
    {

        $id = $req->input("id");

        $product = product::find($id);
        //return $product;

        $product->name = $req->input("name");
        $product->category_id = $req->input("category");





        $product->quantity = $req->input("quantity");
        $product->price = $req->input("price");
        if($product->discount>0)
        {
            $product->final_price = round($req->price - (($req->price * $req->discount) / 100), 2);
        }
        else{
            $product->final_price=$req->input("price");
        }

        $product->priority = $req->input("priority");
        $product->unit = $req->input("unit");
        $product->gender = $req->input("gender");
        $product->description = $req->input("description");

        $product->meta_title = $req->input("meta_name");
        $product->meta_description = $req->input("meta_description");

        if ($req->input('image_change')) {
            if ($req->file("photo") != "") {
                $file = $req->file("photo");
                $extension = $req->file("photo")->getClientOriginalExtension();
                $filename = time() . "." . $extension;
                $file->move("dynamic/products/", $filename);
                $product->photo = "dynamic/products/" . $filename;
            }
        }


        if ($product->save()) {
            $req->session()->flash("product_msg", "true");
            return redirect()->back();
        } else {
            $req->session()->flash("product_msg", "false");
            return redirect()->back();
        }
    }



    public function getMaxId()
    {
        return 1 + product::max("id");
    }

    public function saveproduct(Request $req)
    {

        $req->validate([
            'name' => 'required|max:100|min:2',
            'category' => 'required|exists:categories,id',
            'photo' => 'required'

        ]);

        $product = new product();
        $product->name = $req->input("name");
        $product->category_id = $req->input("category");
        $product->code = "product_" . $this->getMaxId();
        $product->priority = $req->input("priority");

        $product->status = "public";
        $product->price = $req->input("price");
        $product->discount = 0;

        $product->quantity = $req->input("quantity");
        $product->gender = $req->input("gender");
        $product->final_price = $req->input("price");
        $product->description = $req->input("description");
        $product->meta_title = $req->input("meta_name");
        $product->meta_description = $req->input("meta_description");


        if ($req->file("photo") != "") {
            $file = $req->file("photo");
            $extension = $req->file("photo")->getClientOriginalExtension();
            $filename = time() . "." . $extension;
            $file->move("dynamic/products/", $filename);
            $product->photo = "dynamic/products/" . $filename;
        }

        if ($product->save()) {
            $req->session()->flash("product_msg", "true");
            return redirect("/admin/product_description?product=" . $product->code);
        } else {
            $req->session()->flash("product_msg", "false");
            return redirect()->back();
        }
    }

    public function seller_discount_products()
    {
        return view("admin.products.add_discounts", ['all_products' => product::where("discount", "<=", "0")->get(), 'products' => product::where("discount", ">", "0")->get()]);
    }

    public function add_product_to_discount(Request $req)
    {
        $req->validate([
            'discount' => 'required|min:1|max:100',
            'product' => 'required|exists:products,code'
        ]);
        $eid = product::where("code", $req->product)->first();
        if ($eid) {
            $eid->discount = $req->discount;
            $eid->save();
        } else {
            $req->session()->flash("disc_msg", "false");
            return redirect()->back();
        }

        $units = unit::where('product_id', $eid->id)->get();

        if ($units) {
            foreach ($units as $unt) {
                $unit = unit::find($unt->id);
                $unit->discount = $req->discount;
                $unit->final_price = round($unit->price - (($unit->price * $req->discount) / 100), 2);

                $unit->save();
            }
            $req->session()->flash("disc_msg", "true");
            return redirect()->back();
        } else {
            $req->session()->flash("disc_msg", "false");
            return redirect()->back();
        }
    }

    public function delete_discount($pid)
    {
        $eid = product::where("code", $pid)->first();
        if ($eid) {
            $eid->discount = 0;
            $eid->final_price = $eid->price;
            if ($eid->save()) {
                $units = unit::where('product_id', $eid->id)->get();

                if ($units) {
                    foreach ($units as $unt) {
                        $unit = unit::find($unt->id);
                        $unit->discount = 0;
                        $unit->final_price = $unit->price;
                        $unit->save();
                    }

                    return redirect()->back();
                } else {

                    return redirect()->back();
                }
            } else {
                return redirect()->back();
            }
        }
    }

    public function deleteproduct($id)
    {
        $product = product::where('id', $id)->first();
        $product->status = "private";
        if ($product->save()) {
            return redirect()->back()->with('product_msg', 'true');
        } else {
            return redirect()->back()->with('product_msg', 'false');
        }
    }
    public function add_product_images($id)
    {
        $images = product_image::where('product_id', $id)->get();
        return view('admin.products.add_product_images', ['images' => $images, 'product_id' => $id]);
    }
    public function saveimage(Request $req)
    {
        $image = new product_image();
        $image->product_id = $req->input('product_id');
        if ($req->file("photo") != "") {
            $file = $req->file("photo");
            $extension = $req->file("photo")->getClientOriginalExtension();
            $filename = time() . "." . $extension;
            $file->move("dynamic/products/", $filename);
            $image->images = "dynamic/products/" . $filename;
        }
        if ($image->save()) {
            $req->session()->flash("product_msg", "true");
            return redirect()->back();
        } else {
            $req->session()->flash("product_msg", "false");
            return redirect()->back();
        }
    }
    public function delete_product_image($id)
    {
        $image = product_image::find($id);
        $image->delete();
        return redirect()->back();
    }
    public function getunit($unit, $id)
    {
        //return $id;ss
        $unit = unit::where('product_id', $id)->where('unit', $unit)->first();
        if ($unit) {
            return $unit;
        }
    }
    public function reviews($id)
    {
        $reviews = review::where('product_id', $id)->get();
        return view('admin.products.reviews',compact('reviews'));
    }
    public function delete_review(Request $req,$id)
    {
        $review = review::where('id', $id)->delete();
        if($review)
        {
            $req->session()->flash("product_msg", "true");
            return redirect()->back();
        }
        else{
            $req->session()->flash("product_msg", "false");
            return redirect()->back();
        }

    }
}
