<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\product;
use App\Models\product_color;
use App\Models\product_size;
use App\Models\unit;
class ProductDescription extends Controller
{
    //

    public function product_description(Request $req)
    {
        if($req->product)
        {
             $product = product::where("code",$req->product)->with("getSizes","get_units")->with("getColors")->first();

            if($product)
            {
                return view("admin.products.add_product_desc",['product'=>$product]);
            }
            else
            {
                return ['Message'=>'Product Not Found'];
            }
        }
    }

    public function submit_color(Request $req)
    {
        $product=product::where("code",$req->product)->first();
        if($product)
        {
            $color=new product_color();
            $color->color=$req->name;
            $color->color_code=$req->code;
            $color->product_id=$product->id;
            if($color->save())
            {
                return redirect()->back()->with(['color_msg'=>'Color Has been submited successfully']);
            }
            else
            {
                return redirect()->back()->with(['color_msg'=>'Try Again Please']);
            }
        }
        else
        {
            return redirect()->back()->with(['color_msg'=>'Something went wrong Try Again Please']);
        }
    }
    public function submit_size(Request $req)
    {
        
        
        
        if($req->type=="edit" && $req->type!="")
        {
             $size=product_size::where("id",$req->size_id)->first();
            if($size)
            {
               
                $size->size=$req->size;
                 $size->quantity=$req->quantity;
    
               
                if($size->save())
                {
                    return redirect()->back()->with(['size_msg'=>'Size Has been Edit successfully']);
                }
                else
                {
                    return redirect()->back()->with(['size_msg'=>'Try Again Please']);
                }
            }
            else
            {
                return redirect()->back()->with(['size_msg'=>'Something went wrong Try Again Please']);
            }
            
        }
        else{
             $product=product::where("code",$req->product)->first();
            if($product)
            {
                $size=new product_size();
                $size->size=$req->size;
                 $size->quantity=$req->quantity;
    
                $size->product_id=$product->id;
                if($size->save())
                {
                    return redirect()->back()->with(['size_msg'=>'Size Has been submited successfully']);
                }
                else
                {
                    return redirect()->back()->with(['size_msg'=>'Try Again Please']);
                }
            }
            else
            {
                return redirect()->back()->with(['size_msg'=>'Something went wrong Try Again Please']);
            }
        }
       
    }
    public function submit_unit(Request $req)

    {
        //return $req->all();
        $product=product::where("code",$req->product)->first();
        if($product)
        {
            $unit=new unit();
            $unit->unit=$req->unit;
            $unit->price=$req->price;
            $unit->discount=0;
            $unit->final_price=$req->price;;
            $unit->is_visible_main_price=$req->visible;
            $unit->product_id=$product->id;
            if($unit->save())
            {
                return redirect()->back()->with(['unit_msg'=>'Unit Has been submited successfully']);
            }
            else
            {
                return redirect()->back()->with(['unit_msg'=>'Try Again Please']);
            }
        }
        else
        {
            return redirect()->back()->with(['unit_msg'=>'Something went wrong Try Again Please']);
        }
    }
    public function delete_unit($id)
    {
        $check= unit::find($id)->delete();
        return redirect()->back();

    }

    public function delete_size($id)
    {
        $check= product_size::find($id)->delete();
        return redirect()->back();

    }
    public function delete_color($id)
    {
        $check= product_color::find($id)->delete();
        return redirect()->back();

    }
}
