<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\review;

class ReviewController extends Controller
{
    //

    public function submit_review(Request $req)
    {
        $req->validate(['name'=>'required|min:2|max:40',
        'review'=>'required|min:5|max:500',
        
        'product_id'=>'required|exists:products,id'
    ]);
    
    if($req->stars=="")
    {
        return redirect()->back()->with("cart_msg","Please give some stars to give review.");
    }
    $avatars=['av2.png','av3.png','av4.png','av5.png','av1.jpg'];
    $review=new review();
    $review->name=$req->name;
    $review->stars=$req->stars;
    $review->review=$req->review;
    $review->product_id=$req->product_id;
    $review->avatar="static/avatars/".$avatars[rand(0,4)];

    if($review->save())
    {
        return redirect()->back()->with("cart_msg","Thankyou for sharing your reviews!");
    }
   else
    {
        return redirect()->back()->with("cart_msg","A problem occured. Please Try Again");
    }


    }
}
