<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\category;
class product extends Model
{
    use HasFactory;
    public function getCategory()
    {
        return $this->belongsTo(category::class,"category_id");
    }

    public function getSizes()
    {
        return $this->hasMany(product_size::class,"product_id");
    }
    
    public function get_order_products()
    {
        return $this->hasMany(order_product::class,"product_id");
    }

    public function getColors()
    {
        return $this->hasMany(product_color::class,"product_id");
    }
    public function get_units()
    {
        return $this->hasMany(unit::class,"product_id");
    }

    public function getCart()
    {
        return $this->hasMany(cart::class,"product_id");
    }

    public function getOrders()
    {
        return $this->belongsToMany(product::class,"order_products","product_id","order_id")
        ->withPivot("size","color","quantity","price","total_amount");
    }

    public function getReviews()
    {
        return $this->hasMany(review::class,"product_id");
    }
    public function getimages()
    {
        return $this->hasMany(product_image::class,"product_id");
    }
}
