<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();

            $table->string("name");
            $table->string("code")->unique();
            $table->float("price")->nullable();
            $table->float("discount")->nullable();
            $table->string("final_price")->nullable();
            $table->enum("status",['public','private'])->nullable();
            $table->string("photo",300)->nullable();
            $table->bigInteger("category_id")->unsigned()->nullable();
            $table->foreign("category_id")->references("id")->on("categories")->onDelete("cascade");
            $table->enum("gender",['male','female','both'])->nullable();
            $table->string("terms_conditions")->nullable();
            $table->string("short_description")->nullable();
            $table->string("description",1000)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
