@extends('admin.adminmaster')
@section('title')
    Admin-Categories
@endsection

@section('content')
@section('heading')
    Categories
@endsection

<div class="row">
    <div class="col-md-12">
        <div class="btn-group text-right d-block" role="group" aria-label="Basic example">
            <a href="{{ route('addcategory') }}" class="btn btn-sm btn-primary float-end "><i class="far fa-plus"></i> Add
                New
                Category</a>

        </div>
        <div class="card">
            <div class="card-header">
                <h6> View Categories </h6>
            </div>
            <div class="card-body">
                <table id="datatable" class="table table-bordered dt-responsive nowrap"
                    style="border-collapse: collapse; border-spacing: 0; width: 100%;">

                        <thead>
                            <tr>
                                <th>ID
                                </th>
                                <th>Name
                                </th>
                                <th>Code
                                </th>
                                <th>Status
                                </th>

                                <th>Action
                                </th>
                            </tr>
                        </thead>
                    <tbody>
                        @foreach ($categories as $categ)
                            <tr>
                                <td>{{ $categ['id'] }}
                                </td>
                                <td>{{ $categ['name'] }}
                                </td>
                                <td>{{ $categ['code'] }}
                                </td>
                                <td>{{ $categ['status'] }}
                                </td>

                                <td>
                                    <a href="{{ route('edit_category', $categ['id']) }}"
                                        class="bg-warning text-dark py-2 px-3 rounded"><i class="fa fa-edit"></i></a>

                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>



</div>
@section('script')
    <script type="text/javascript">
        $("#sidecateg").addClass("sidelinkactive");
    </script>
@endsection




@endsection
