@extends('admin.adminmaster')
@section('title')
    Admin-Orders
@endsection

@section('content')
@section('heading')
    Orders
@endsection

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">  <h6> View Orders </h6></div>
            <div class="card-body">
                <table id="datatable" class="table table-bordered dt-responsive nowrap"
                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
    <thead>
        <tr>
            <th>ID
            </th>
            <th>Price
            </th>
            <th>Name</th>
            <th>Phone</th>
            <th>Placed At
            </th>
            <th>Status
            </th>
            <th width="10%">Action
            </th>
        </tr>
    </thead>
    <tbody>
        @foreach ($orders as $order)
            @if ($order->status == 'pending')
                <tr class="alert-warning text-dark">
                @elseif($order->status == 'processing')
                <tr class="alert-info text-dark">
                @elseif($order->status == 'completed')
                <tr class="alert-success">
                @elseif($order->status == 'rejected')
                <tr class="alert-danger">
                @else
                <tr>
            @endif

            <td>{{ $order['order_no'] }}
            </td>
            <td>{{ $order['total_price'] }} USD
            </td>
            <td>{{ $order['name'] }}
            </td>
            <td>{{ $order['phone'] }}
            </td>

            <td>{{ $order['created_at'] }}
            </td>
            <td>{{ $order['status'] }}
            </td>

            <td>
                <a href={{ route('admin_order_detail', $order->order_no) }} class="editactionbtn"><i
                        class="fad fa-edit"></i></a>
            </td>
            </tr>
        @endforeach
    </tbody>
</table>
            </div>
        </div>
    </div>



</div>
@section('script')
    <script type="text/javascript">
        $("#sideorder").addClass("sidelinkactive");
    </script>
@endsection




@endsection
