@extends('admin.adminmaster')
@section('title')
    Admin-Product
@endsection

@section('content')
@section('heading')
    Product
@endsection

<div class="row">

    <div class="col-md-12">
        <div class="card">
            @if (session('color_msg'))
                <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                    <strong> Message! </strong> {{ session('color_msg') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            @endif
            <div class="card-header">
                <h6> Product Colors</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-7">
                        <table class="table table-sm table-sm-responsive size-sm">
                            <tr>
                                <th>
                                    Color
                                </th>
                                <th>
                                    Code
                                </th>
                                <th>
                                    Visual
                                </th>
                                <th>
                                    Delete
                                </th>
                            </tr>
                            @foreach ($product['getColors'] as $color)
                                <tr>
                                    <td>{{ $color->color }}</td>
                                    <td>{{ $color->color_code }}</td>
                                    <td><span class="py-0 px-3 size-vsm"
                                            style="color:{{ $color->color_code }};background-color:{{ $color->color_code }}"></span>
                                    </td>
                                    <td>
                                        <a href="{{ route('delete_color', $color->id) }}" class="deleteactionbtn"><i
                                                class="fad fa-trash"></i></a>

                                    </td>
                                </tr>

                            @endforeach
                        </table>
                    </div>
                    <div class="col-md-5">
                        <form method="POST" action="{{ route('submit_color') }}">
                            @csrf
                            <input type="hidden" value="{{ $product->code }}" name="product">
                            <div class="form-group mt-3">
                                <label class="size-nm text-muted">Color Name:</label>
                                <input type="text" name="name" class="form-control ctextfield size-sm"
                                    placeholder="Name..." required>
                            </div>
                            <div class="form-group mt-3">
                                <label class="size-nm text-muted">Color Hash Code:</label>
                                <input type="text" name="code" class="form-control ctextfield size-sm"
                                    placeholder="Code...">
                            </div>
                            <div class="form-group mt-3">
                                <input type="submit" name="submit_color" class="btn btn-sm btn-primary p-1 form-control">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            @if (session('size_msg'))
                <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                    <strong> Message! </strong> {{ session('size_msg') }}
                      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            @endif
            <div class="card-header">
                <h6> Product Sizes</h6>
            </div>
            <div class="card-body">




                    <div class="row">
                        <div class="col-md-7">
                            <table class="table table-sm table-sm-responsive size-sm">
                                <tr>
                                    <th>
                                        Sr.
                                    </th>
                                    <th>
                                        Size
                                    </th>
                                     <th>
                                        Quantity
                                    </th>
                                    <th>
                                        Delete
                                    </th>
                                </tr>
                                @php $count=1;@endphp
                                @foreach ($product['getSizes'] as $size)
                                    <tr>
                                        <td>
                                            {{ $count++ }}
                                        </td>

                                        <td>
                                            {{ $size['size'] }}
                                        </td>
                                         <td>
                                            {{ $size['quantity'] }}
                                        </td>

                                        <td>
                                            <a href="{{ route('delete_size', $size->id) }}" class="deleteactionbtn"><i
                                                    class="fad fa-trash"></i></a>
                                                     <a  data-toggle="modal" data-target="#exampleModal{{$size->id}}" class=""><i
                                                class="fad fa-edit"></i></a>
                                        </td>
                                    </tr>
                                    <div class="modal fade" id="exampleModal{{$size->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                          <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                              <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">Edit Quantity</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                  <span aria-hidden="true">&times;</span>
                                                </button>
                                              </div>
                                              <div class="modal-body">
                                                 <form method="POST" action="{{ route('submit_size') }}">
                                                        @csrf
                                                        <input type="hidden" value="{{ $size->id }}" name="size_id">
                                                         <input type="hidden" value="edit" name="type">
                                                        <div class="form-group mt-3">
                                                            <label class="size-nm text-muted">Size</label>
                                                            <input type="text" name="size" value="{{ $size['size'] }}" class="form-control ctextfield size-sm"
                                                                placeholder="Size..." required>
                                                        </div>
                                                          <div class="form-group mt-3">
                                                            <label class="size-nm text-muted">Quantity</label>
                                                            <input type="text" name="quantity" value="{{ $size['quantity'] }}" class="form-control ctextfield size-sm"
                                                                placeholder="Quantity..." required>
                                                        </div>

                                                        <div class="form-group mt-3">
                                                            <input type="submit" name="submit_color" class="btn btn-sm btn-primary p-1 form-control">
                                                        </div>
                                                    </form>
                                              </div>

                                          </div>
                                        </div>
                                @endforeach
                            </table>
                        </div>

                        <div class="col-md-5">
                            <form method="POST" action="{{ route('submit_size') }}">
                                @csrf
                                <input type="hidden" value="{{ $product->code }}" name="product">
                                <div class="form-group mt-3">
                                    <label class="size-nm text-muted">Size</label>
                                    <input type="text" name="size" class="form-control ctextfield size-sm"
                                        placeholder="Size..." required>
                                </div>
                                  <div class="form-group mt-3">
                                    <label class="size-nm text-muted">Quantity</label>
                                    <input type="text" name="quantity" class="form-control ctextfield size-sm"
                                        placeholder="Quantity..." required>
                                </div>

                                <div class="form-group mt-3">
                                    <input type="submit" name="submit_color" class="btn btn-sm btn-primary p-1 form-control">
                                </div>
                            </form>
                        </div>
                    </div>







            </div>
        </div>

        <div class="card">
            @if (session('unit_msg'))
                <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                    <strong> Message! </strong> {{ session('unit_msg') }}
                      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            @endif
            <div class="card-header">
                <h6> Product Units</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-7">
                        <table class="table table-sm table-sm-responsive size-sm">
                            <tr>
                                <th>
                                    Sr.
                                </th>
                                <th>
                                    Unit
                                </th>
                                <th>
                                    Price
                                </th>
                                <th>
                                    Show At Main
                                </th>
                                <th>
                                    Discount
                                </th>
                                <th>
                                    Final Price
                                </th>
                                <th>
                                    Action
                                </th>
                            </tr>
                            @php $count=1;@endphp
                            @foreach ($product['get_units'] as $unit)
                                <tr>
                                    <td>
                                        {{ $count++ }}
                                    </td>

                                    <td>
                                        {{ $unit['unit'] }}
                                    </td>
                                    <td>
                                        {{ $unit['price'] }}
                                    </td>
                                    <td>
                                        {{ $unit['is_visible_main_price'] }}
                                    </td>
                                    <td>
                                        {{ $unit['discount'] }}%
                                    </td>
                                    <td>
                                        {{ $unit['final_price'] }}
                                    </td>

                                    <td>
                                        <a href="{{ route('delete_unit', $unit->id) }}" class="deleteactionbtn"><i
                                                class="fad fa-trash"></i></a>
                                    </td>
                                </tr>
                            @endforeach
                        </table>
                    </div>

                    <div class="col-md-5">
                        <form method="POST" action="{{ route('submit_unit') }}">
                            @csrf
                            <input type="hidden" value="{{ $product->code }}" name="product">
                            <div class="form-group mt-3">
                                <label class="size-nm text-muted">Unit</label>
                                <input type="text" name="unit" class="form-control ctextfield size-sm"
                                    placeholder="Unit..." required>
                            </div>
                            <div class="form-group mt-3">
                                <label class="size-nm text-muted">Price</label>
                                <input type="text" name="price" class="form-control ctextfield size-sm"
                                    placeholder="Price..." required>
                            </div>
                            <div class="form-group mt-3">
                                <label class="size-nm text-muted">Visible At Main Price</label>
                                <select name="visible" class="form-control">
                                    <option value="">Select One</option>
                                    <option value="yes">yes</option>
                                    <option value="no">No</option>
                                </select>
                            </div>

                            <div class="form-group mt-3">
                                <input type="submit" name="submit_color" class="btn btn-sm btn-primary p-1 form-control">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>






</div>
@section('script')
    <script type="text/javascript">
        $("#sideproducts").addClass("sidelinkactive");
    </script>
@endsection




@endsection
