@extends('user.usermaster')

@section('title', ' Home')
@section('stylesheet')
    <style>
        .colorpick:hover {
            cursor: pointer;
        }

    </style>
@endsection

@section('breadcrumb')
    <a href="" class="size-sm text-muted">User Cart</a>
@endsection
@section('content')




    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="blockdiv mt-3">
                    <h6 class="mb-3 text-center"> <img src="{{ asset('static/images/mainlogo.PNG') }}"
                            class="float-start" style="width:70px;height:40px"> Fill The Information to Place Order</h6>
                    <form method="post" action="{{ route('place_order') }}">
                        @csrf
                        <table class="table table-sm table-sm-responsive form-table2 table-borderless">
                            <tr>
                                <td>
                                    <div class="form-group mt-3">
                                        <label class="text-muted size-sm">First Name</label>
                                        <input type="text" name="name" class="form-control size-nm ctextfield"
                                            placeholder="First Name...." required>
                                    </div>
                                </td>
                                <td>
                                    <div class="form-group mt-3">
                                        <label class="text-muted size-sm">Last Name</label>
                                        <input type="text" name="lname" class="form-control size-nm ctextfield"
                                            placeholder="Last name...." required>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <div class="form-group mt-3">
                                        <label class="text-muted size-sm">Email</label>
                                        <input type="email" name="email" class="form-control size-nm ctextfield"
                                            placeholder="Email...." required>
                                    </div>
                                </td>
                                <td>
                                    <div class="form-group mt-3">
                                        <label class="text-muted size-sm">Phone</label>
                                        <input type="number" name="phone" class="form-control size-nm ctextfield"
                                            placeholder="Phone...." required>
                                    </div>
                                </td>


                            </tr>
                            <tr>
                                <td>
                                    <div class="form-group mt-3">
                                        <label class="text-muted size-sm">Phone2</label>
                                        <input type="number" name="phone2" class="form-control size-nm ctextfield"
                                            placeholder="Phone2...." required>
                                    </div>
                                </td>

                                <td>
                                    <div class="form-group mt-3">
                                        <label class="text-muted size-sm">State</label>
                                        <select name="state" onchange="getcities()" id="state"
                                            class="form-control size-nm ctextfield" required>
                                            <option>select state</option>
                                            @foreach ($states as $state)
                                                <option value="{{ $state['state'] }}">{{ $state['state'] }}</option>
                                            @endforeach
                                        </select>

                                    </div>
                                </td>


                            </tr>
                            <tr>
                                <td>
                                    <div class="form-group mt-3">
                                        <label class="text-muted size-sm">City</label>
                                        <select name="city" id="city" class="form-control size-nm ctextfield" required>

                                        </select>
                                    </div>
                                </td>
                                <td>
                                    <div class="form-group mt-3">
                                        <label class="text-muted size-sm">Street</label>
                                        <input type="text" name="street" class="form-control size-nm ctextfield"
                                            placeholder="street...." required>

                                        </select>
                                    </div>
                                </td>


                            </tr>
                            <tr>
                                <td>
                                    <div class="form-group mt-3">
                                        <label class="text-muted size-sm">Postal</label>
                                        <input type="number" name="postal_code" class="form-control size-nm ctextfield"
                                            placeholder="Postal Code...." required>
                                    </div>
                                </td>

                                <td>
                                    <div class="form-group mt-3">
                                        <label class="text-muted size-sm">.</label><br>
                                        <input type="submit" name="submit" class="size-nm btn btn-sm cbtn float-end"
                                            value="Done">
                                    </div>
                                </td>
                            </tr>


                        </table>








                    </form>

                </div>

            </div>
            <div class="col-md-4">

                <div class="card p-2">
                    <div class="card-header">
                        <h5>Order Summary</h5>
                    </div>
                    <div class="card-body">

                        <table  class="table table-borderless table-md table-md-responsive size-md table-hover " >
                            <thead>
                            <tr>
                                <th>Image
                                </th>
                                <th>Name
                                </th>
                                <th>Quantity</th>

                                <th>Price
                                </th>


                            </tr>
                            </thead>
                            <tbody>
                                @foreach ($carts as $pro)
                               <tr>
                                <td><img src="{{ asset($pro->getProduct->photo) }}" class="img img-fluid logo-nm">
                                </td>

                                <td>{{ $pro->getProduct->name }}
                                </td>
                                <td> {{ $pro->quantity }}
                                </td>
                                <td>{{ $pro->getProduct->final_price }} AUD
                                </td>


                               </tr>
                               @endforeach
                               <tr>
                                   <td>
                                    <h6 class="text-dark ">Total Price: {{ $pro->total_amount }}</h6>
                                   </td>
                               </tr>
                            </tbody>
                        </table>


                    </div>



                </div>
            </div>

        </div>
    </div>
    </div>


@endsection
@section('specificscripts')
    <script>
        $(".colorpick").click(function() {
            $("#color").val($(this).attr("data-color"));
            $(".colorpick").css({
                "border": "none"
            });
            $(this).css({
                "border": "2px solid black"
            });
        })

        function getcities() {

            var a = $("#state").val();

            console.log(a);

            $.ajax({
                url: "/getcities/" + a,
                type: "GET",
                data: {
                    data: "data"
                },
                success: function(city) {
                    // console.log(maincategory);
                    $("#city").html("");
                    for (var l = 0; l < city.length; l++) {
                        $("#city").append("<option value='" + city[l].place + "'>" + city[l].place +
                            "</option>");
                    }



                }
            })



        }
    </script>
@endsection
