@extends('user.usermaster')

@section('title', ' Home')
@section('stylesheet')
    <style>
        .colorpick:hover {
            cursor: pointer;
        }

    </style>
@endsection

@section('breadcrumb')
    <a href="" class="size-sm text-muted">User Cart</a>
@endsection
@section('content')




    <div class="container-fluid">
        <div class="row">
            <div class="col-md-6 offset-md-3">
                <h6 class="text-center">Must Take a Screen Shot</h6>

                <div id="print_div">
                    <div class="blockdiv mt-3">
                        <center>
                            <div id="order_info">
                                <h6 class="mb-1">Order Status
                                    <hr>
                                </h6>


                                    <h5 class="text-success text-center">Your Order is pending. Pay to proceed!</h5>
                                    <p >Total Amount: $<span id="price">{{ $order['total_price'] }}</span></p>
                                      <span>Payment Status is Pending</span>


                                <h6 class="text-muted">Order Token</h6> <span>(Please copy that token to check your
                                    order)</span>
                                <h6>{{ $order['order_no'] }}</h6>
                                <p class="size-nm"><span class="text-muted">Placed at:
                                    </span>{{ $order['created_at'] }}</p>
                                    <div id="smart-button-container" style="width: 400px">
                                        <div style="text-align: center;">
                                            <div id="paypal-button-container"></div>
                                        </div>
                                    </div>
                                    <form method="post" action="{{route('orderupdate')}}" id="frm">
                                        @csrf
                                        <input type="hidden" class="form-control" name="oid" value="{{{ $order['id'] }}}" >
                                        <input type="hidden" class="form-control" name="status" value="completed">
                                        <input type="hidden"  class="form-control" name="tid" id="tid">

                                    </form>
                            </div>

                        </center>
                    </div>

                    <br>
                </div>
                <a href="{{ route('user_orders') }}" class="mt-2 btn btn-sm float-end cbtn size-sm">Go to Order Page</a>
            </div>
        </div>
    </div>


@endsection

@section('specificscripts')
<script
src="https://www.paypal.com/sdk/js?client-id=AYeHG3ljJPiIz_ApAiuCDRE8qA7aKepD02kdSfpBkhUZDSdg75M9edrnN2JAkw9UtqPiCi5WUZNy5WlO&enable-funding=venmo&currency=AUD";-->
data-sdk-integration-source="button-factory"></script>
<!-- <script-->
<!--src="https://www.paypal.com/sdk/js?client-id=AeIDYc4_OnnKIm2zOcXSJp7zDn021Aw30NkRxdwNMfVuWUOWaWi7ZZ_GtKndkF8d7Pvr85SWtQJlp1IK&enable-funding=venmo&currency=AUD";-->
<!--data-sdk-integration-source="button-factory"></script> -->
    <script>


        var price=$('#price').html();

        function initPayPalButton() {
            paypal.Buttons({
                style: {
                    shape: 'rect',
                    color: 'gold',
                    layout: 'vertical',
                    label: 'paypal',
                },
                createOrder: function(data, actions) {
                    return actions.order.create({

                        purchase_units: [{
                            "amount": {
                                "currency_code": "AUD",
                                "value": price
                            }
                        }]
                    });
                },

                onApprove: function(data, actions) {

                    return actions.order.capture().then(function(orderData) {
                        // Full available details
                        console.log('Capture result', orderData, JSON.stringify(orderData, null,
                        2));
                        if(orderData['purchase_units'][0]['payments']['captures'][0]['id'])
                        {
                            $('#tid').val(orderData['purchase_units'][0]['payments']['captures'][0]['id']);
                            // $('#status').val(orderData['purchase_units'][0]['payments']['captures'][0]['status']);
                        }
                        // Show a success message within this page, e.g.
                        const element = document.getElementById('paypal-button-container');
                        element.innerHTML = '';
                        element.innerHTML = '<h3>Thank you for your payment!</h3>'; // Or go to another
                        URL: actions.redirect('thank_you.html');

                        $('#frm').submit();
                    });
                },
                onError: function(err) {
                    console.log(err);
                }
            }).render('#paypal-button-container');
        }
        initPayPalButton();
    </script>
@endsection
{{-- Capture result Object {
    "id": "6BX9047422706633X",
    "intent": "CAPTURE",
    "status": "COMPLETED",
    "purchase_units": [
      {
        "reference_id": "default",
        "amount": {
          "currency_code": "AUD",
          "value": "1.00"
        },
        "payee": {
          "email_address": "barco.03-facilitator@gmail.com",
          "merchant_id": "YQZCHTGHUK5P8"
        },
        "shipping": {
          "name": {
            "full_name": "John Doe"
          },
          "address": {
            "address_line_1": "1 Main St",
            "admin_area_2": "San Jose",
            "admin_area_1": "CA",
            "postal_code": "95131",
            "country_code": "US"
          }
        },
        "payments": {
          "captures": [
            {
              "id": "3H552966JK939071K",
              "status": "COMPLETED",
              "amount": {
                "currency_code": "AUD",
                "value": "1.00"
              },
              "final_capture": true,
              "seller_protection": {
                "status": "ELIGIBLE",
                "dispute_categories": [
                  "ITEM_NOT_RECEIVED",
                  "UNAUTHORIZED_TRANSACTION"
                ]
              },
              "create_time": "2022-03-21T19:42:01Z",
              "update_time": "2022-03-21T19:42:01Z"
            }
          ]
        }
      }
    ],
    "payer": {
      "name": {
        "given_name": "John",
        "surname": "Doe"
      },
      "email_address": "sb-7mlky14361168@business.example.com",
      "payer_id": "93YV92YNPR5W4",
      "phone": {
        "phone_number": {
          "national_number": "4089317860"
        }
      },
      "address": {
        "address_line_1": "1 Main St",
        "admin_area_2": "San Jose",
        "admin_area_1": "CA",
        "postal_code": "95131",
        "country_code": "US"
      }
    },
    "create_time": "2022-03-21T19:41:44Z",
    "update_time": "2022-03-21T19:42:01Z",
    "links": [
      {
        "href": "https://api.sandbox.paypal.com/v2/checkout/orders/6BX9047422706633X",
        "rel": "self",
        "method": "GET"
      }
    ]
  } --}}
