<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\PosterController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ListingController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\ProductDescription;
use App\Http\Controllers\MailController;
use App\Http\Controllers\ReviewController;
use App\Http\Controllers\CJController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
// Clear application cache:
Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
    return 'Application cache has been cleared';
});

//Clear route cache:
Route::get('/test/route-cache', function() {
	Artisan::call('route:cache');
    return 'Routes cache has been cleared';
});

Route::get('/shipstation-xml',[OrderController::class,"shipstation"] )->name("shipstation-xml");
Route::get('/getcategories',[HomeController::class,"getcategories"] )->name("getcategories");
Route::get('/new',[HomeController::class,"index2"] )->name("index2");
Route::get('/contact-us',[HomeController::class,"contact_us"] )->name("contact-us");
Route::get('/about-us',[HomeController::class,"about_us2"] )->name("about-us");
Route::get("shipping_policy",[HomeController::class,"about_us"])->name("shipping_policy");
Route::get("return-policy",[HomeController::class,"return_policy"])->name("return-policy");
Route::get("privacy_policy",[HomeController::class,"privicy_policy"])->name("privacy_policy");
Route::get("termsconditions",[HomeController::class,"termsconidtions"])->name("termsconditions");
Route::post('contact_mail',[MailController::class,"contact_mail"] )->name("contact_mail");

Route::get('/',[HomeController::class,"index"] )->name("index");
// Route::get('/',[ListingController::class,"products"] )->name("products");
Route::get('product/{code}',[ProductController::class,"viewproduct"] )->name("product");
Route::get('shop/{categ?}',[ListingController::class,"products"] )->name("shop");
Route::post('add_to_cart',[CartController::class,"add_to_cart"] )->name("add_to_cart");
Route::get('user_cart',[CartController::class,"user_cart"] )->name("user_cart");
Route::get('getcities/{a}',[CartController::class,"getcities"] )->name("getcities");
Route::get('checkout',[CartController::class,"checkout"] )->name("checkout");
Route::post('place_order',[OrderController::class,"place_order"] )->name("place_order");
Route::post('update_cart_quantity',[CartController::class,"update_cart_quantity"] )->name("update_cart_quantity");
Route::post('delete_cart',[CartController::class,"delete_cart"] )->name("delete_cart");
Route::match(['get','post'],'orders',[OrderController::class,"user_orders"] )->name("orders");
Route::get('order-detail',[OrderController::class,'order_info'])->name("order-detail");
Route::get('mail',[MailController::class,"order_mail"] )->name("order_mail");
Route::post('submit_review',[ReviewController::class,"submit_review"] )->name("submit_review");
Route::get('/getunit/{unit}/{id}',[ProductController::class,"getunit"] )->name("getunit");
Route::post('success',[OrderController::class,"success"] )->name("success");

Route::post('orderupdate',[OrderController::class,"orderupdate"] )->name("orderupdate");

Route::prefix("admin")->group( function() {
    Route::get("login",[AdminController::class,"login"])->name("login");
     Route::get("logout",[AdminController::class,"logout"])->name("logout");
    Route::post("verifylogin",[AdminController::class,"verifylogin"])->name("verifylogin");
    Route::group(['middleware'=>['admin_login_auth']], function(){

        /////////cj
Route::get('get-token', [CJController::class, 'getAccessToken'])->name("get-token");
Route::get('cj/products', [CJController::class, 'getProducts'])->name("cj.products");
Route::post('/cj/import', [CJController::class, 'importProduct'])->name('cj.import');
        Route::get("dashboard",[DashboardController::class,"dashboard"])->name("dashboard");
                Route::get("analysis",[DashboardController::class,"analysis"])->name("analysis");

                Route::get("reports",[DashboardController::class,"reports"])->name("reports");

        Route::get("orders",[OrderController::class,"admin_orders"])->name("admin_orders");
        Route::get("order_detail/{order}",[OrderController::class,"admin_order_detail"])->name("admin_order_detail");
        Route::post("update_order_status",[OrderController::class,"update_order_status"])->name("update_order_status");

        Route::get("categories",[CategoryController::class,"categories"])->name("categories");
        Route::get("addcategory",[CategoryController::class,"addcategory"])->name("addcategory");
        Route::post("savecategory",[CategoryController::class,"savecategory"])->name("savecategory");

        Route::get("posters",[PosterController::class,"posters"])->name("posters");
        Route::get("addposter",[PosterController::class,"addposter"])->name("addposter");
        Route::post("saveposter",[PosterController::class,"saveposter"])->name("saveposter");

        Route::get("products",[ProductController::class,"products"])->name("products");
        Route::get("addproduct",[ProductController::class,"addproduct"])->name("addproduct");
        Route::post("saveproduct",[ProductController::class,"saveproduct"])->name("saveproduct");
        Route::match(['get','post'],"product_description",[ProductDescription::class,"product_description"])->name("product_description");
        Route::post("submit_color",[ProductDescription::class,"submit_color"])->name("submit_color");
        Route::post("submit_size",[ProductDescription::class,"submit_size"])->name("submit_size");
        Route::post("submit_unit",[ProductDescription::class,"submit_unit"])->name("submit_unit");
        Route::get("delete_size/{id}",[ProductDescription::class,"delete_size"])->name("delete_size");
        Route::get("delete_color/{id}",[ProductDescription::class,"delete_color"])->name("delete_color");
        Route::get("delete_unit/{id}",[ProductDescription::class,"delete_unit"])->name("delete_unit");
        Route::get("customers",[UserController::class,"customers"])->name("customers");
        Route::get("seller_discount_products",[ProductController::class,"seller_discount_products"])->name("seller_discount_products");
        Route::post("add_product_to_discount",[ProductController::class,"add_product_to_discount"])->name("add_product_to_discount");
        Route::get("delete_discount/{pid?}",[ProductController::class,"delete_discount"])->name("delete_discount");
    ///////new
    Route::get("editproduct/{id}",[ProductController::class,"editproduct"])->name("editproduct");
    Route::get("deleteproduct/{id}",[ProductController::class,"deleteproduct"])->name("deleteproduct");
    Route::post("updateproduct",[ProductController::class,"updateproduct"])->name("updateproduct");

    Route::get("deleteposter/{id}",[PosterController::class,"deleteposter"])->name("deleteposter");
    Route::post("add_delivery_detail",[OrderController::class,"add_delivery_detail"])->name("add_delivery_detail");

    Route::get("add_product_images/{id}",[ProductController::class,"add_product_images"])->name("add_product_images");
    Route::post("saveimage",[ProductController::class,"saveimage"])->name("saveimage");
    Route::get("delete_product_image/{id}",[ProductController::class,"delete_product_image"])->name("delete_product_image");

      //////reviews
        Route::get("reviews/{id}", [ProductController::class, "reviews"])->name("reviews");
        Route::get("delete_review/{id}", [ProductController::class, "delete_review"])->name("delete_review");



    Route::get("update_status/{id}/{public}",[CategoryController::class,"update_status"])->name("update_status");

    Route::get("update_status/{id}/{private}",[CategoryController::class,"update_status_private"])->name("update_status_private");
    Route::get("edit_category/{id}",[CategoryController::class,"edit_category"])->name("edit_category");

    Route::post("editcategory/",[CategoryController::class,"editcategory"])->name("editcategory");
});


});
