<?php $__env->startSection('title'); ?>
    Seller-Products
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php $__env->startSection('heading'); ?>
    Products
<?php $__env->stopSection(); ?>

<div class="row">

    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <form method="post" action="<?php echo e(route('add_product_to_discount')); ?>">
                    <?php echo csrf_field(); ?>
                    <h6>Add Discount</h6>
                    <hr>
                    <?php if(session('disc_msg')): ?>
                        <?php if(session('disc_msg') == 'true'): ?>
                            <br>
                            <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                                <strong> Success! </strong> Product has been Added Into Discount
                                 <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-danger alert-dismissible fade show size-nm" role="alert">
                                <strong> Failed! </strong> Some Issue Occured. Try Again
                                 <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                    <table class=" table table-sm table-sm-responsive size-nm table-hover ">
                        <tr>
                            <td width="50%" class="p-2">
                                <input list="products" autocomplete="off" placeholder="Search Product...." name="product"
                                    value="<?php echo e(old('product')); ?>" id="product" class="form-control ctextfield size-sm">

                                <datalist id="products">
                                    <?php $__currentLoopData = $all_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($product['code']); ?>" /><?php echo e($product['name']); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </datalist>
                                <span class="text-danger size-sm">
                                    <?php $__errorArgs = ['product'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </span>

                            </td>
                            <td class="p-2">
                                <input type="number" placeholder="Enter Discount" max="80" min="1" name="discount"
                                    value="<?php echo e(old('discount')); ?>" class="form-control ctextfield size-sm">
                                <span class="text-danger size-sm">
                                    <?php $__errorArgs = ['discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </span>
                            </td>
                            <td class="p-2">
                                <input type="submit" name="submit" class="btn btn-sm btn-success" value="Apply">
                            </td>
                        </tr>

                    </table>
                </form>

                <h6>Discount Products</h6>
                <hr>
                <table id="datatable" class="table table-bordered dt-responsive nowrap"
                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                        <tr>
                            <th>ID
                            </th>
                            <th>Name
                            </th>

                            <th>Discount
                            </th>


                            <th>
                                Image
                            </th>
                            <th width="10%">Action
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($product['code']); ?>

                                </td>
                                <td><?php echo e($product['name']); ?>

                                </td>


                                <td><?php echo e($product['discount']); ?>%
                                </td>




                                <td><img src="<?php echo e(asset($product['photo'])); ?>" class="img img-fluid logo-nm">
                                </td>
                                <td>
                                    <a href="<?php echo e(route('product_description')); ?>?product=<?php echo e($product['code']); ?>" class=""><i
                                            class="fad fa-edit"></i></a> |
                                    <a href="<?php echo e(route('delete_discount', $product->code)); ?>" class="deleteactionbtn"
                                        title="Remove from Discount"><i class="fad fa-trash"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>

    <br>

</div>
</div>





<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/painvdmk/public_html/resources/views/admin/products/add_discounts.blade.php ENDPATH**/ ?>